﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Projet  : Portfolio Multimédia
# Fichier : ProjetChapitre9.fla
# Classe  : BarreNavigation.as
#
*/

//Définition de la classe Menu extends MovieClip
class BarreNavigation extends MovieClip {


	
 private var listeVignettes:Array;
 
  
 private function aGauche(btnG:MovieClip, btnD:MovieClip,lm:Number, ltv:Number):Void{
  for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].seDeplaceAGauche(i,btnG,btnD, lm, ltv );
  }
 }

 private function aDroite(btnG:MovieClip, btnD:MovieClip, lm:Number, ltv:Number):Void{
  for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].seDeplaceADroite(i,btnG, btnD, lm, ltv );
  }
 }

 private function arreterTout():Void{
  for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].arreterLeDeplacement();
  }
 }

 function ajouterUneVignette(cible:MovieClip, p:Number, c:String, n:Number, r:String):Void{ 
  var nvelleVignette:Vignette = new Vignette(cible, p, c, n, r);
  listeVignettes.push(nvelleVignette);
 }

 // Définition de la fonction constructeur 
 public function BarreNavigation(cible:MovieClip, p:Number, nx:Number, ny:Number, c:String, n:Number, r:String) {
  var cetteBarre:BarreNavigation = this;
  var tmp:MovieClip;

  var nbVignettes:Number = n;
  var niveau:Number = p;

  var mask:MovieClip = cible.attachMovie("MaskNavigationClp","mask", niveau);
  mask._x = nx ;
  mask._y = ny;
  cible.setMask(mask);
  var largeurMask:Number = mask._width;
  var largeurTotalVignette:Number = Vignette.largeur*nbVignettes;

  niveau++;
 
  var  btnD:MovieClip = cible.attachMovie("BtnDroitClp", "adroite", niveau );
  btnD._x = 2*mask._width / 3 ;
  btnD._y = 4*Vignette.largeur/ 3;
  btnD.onRollOver = function():Void {
   this.gotoAndStop(2);
   cetteBarre.aGauche(btnG, this,largeurMask, largeurTotalVignette);
  }
  btnD.onRollOut = function():Void {
   this.gotoAndStop(1);
   cetteBarre.arreterTout();
  }

  niveau++;
  var  btnG:MovieClip = cible.attachMovie("BtnGcheClp", "agauche", niveau );
  btnG._x = mask._width / 3 ;
  btnG._y = 4*Vignette.largeur/3 ;
  btnG._visible = false;
  btnG.onRollOver = function () {
   this.gotoAndStop(2);
   cetteBarre.aDroite(this, btnD, largeurMask, largeurTotalVignette);
  }
  btnG.onRollOut = function():Void {
   this.gotoAndStop(1);
   cetteBarre.arreterTout();
  }

  niveau++;
  listeVignettes = new Array();
  for(var i:Number = 0; i < nbVignettes; i++) {
    cetteBarre.ajouterUneVignette(cible, niveau+i , c, i, r);
   
  }
  // Rechercher toutes les vignettesà partir du niveau nbVignettes jusqu'à ce que le niveau ne contienne plus d'instance
  var j:Number = nbVignettes; 
  do {
    tmp = cible.getInstanceAtDepth(niveau+j);
    j++;
    // Détruire les instances 
    tmp.removeMovieClip();
  }while (tmp != undefined);

  for(var i:Number = 0; i < nbVignettes; i++) {
    cetteBarre.listeVignettes[i].sAffiche(Vignette.largeur*i+nx, ny);
  }
 }

}
